<?php
// Incluir archivo de configuración de la base de datos
include('php/config/conexion.php');

session_start();

if (isset($_SESSION['usuario'])) {
   
}else{
    header('Location: index.php');
    exit();
}



?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Formulario de Configuración</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body, html {
            height: 100%;
            display: flex;
            justify-content: center;
            align-items: center;
            background-color: #24272c;
        }
        .form-container {
            width: 100%;
            width: 500px;
            max-width: 600px; /* Ajuste el ancho máximo del formulario */
            padding: 30px;
            background-color: #ffffff;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .message {
            display: none;
            margin-top: 10px;
        }
    </style>
</head>
<body>

<div class="form-container">
    <h2 class="text-center mb-4">CONFIG-IP</h2>
    <form id="configForm">
        <div class="mb-3">
            <label for="ipInput_ddoxs" class="form-label">IP</label>
            <input type="text" class="form-control" id="ipInput_ddoxs" placeholder="Ingrese la dirección IP">
        </div>
        <div class="mb-3">
            <label for="portInput_ddoxs" class="form-label">Puerto</label>
            <input type="text" class="form-control" id="portInput_ddoxs" placeholder="Ingrese el puerto">
        </div>
        <div class="mb-3">
            <label for="userInput_ddoxs" class="form-label">Usuario</label>
            <input type="text" class="form-control" id="userInput_ddoxs" placeholder="Ingrese el nombre de usuario">
        </div>
        <div class="mb-3">
            <label for="passwordInput_ddoxs" class="form-label">Contraseña</label>
            <input type="text" class="form-control" id="passwordInput_ddoxs" placeholder="Ingrese la contraseña">
        </div>
        <button type="submit" class="btn btn-primary w-100">Guardar</button>
    </form>
    <div id="successMessage" class="alert alert-success message">Datos guardados</div>
    <div id="errorMessage" class="alert alert-danger message">Todos los campos deben tener al menos 5 caracteres</div>
</div>


<script>
    document.addEventListener('DOMContentLoaded', function() {
        fetch('php/obtener_config_ip.php')
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                document.getElementById('ipInput_ddoxs').value = data.ip;
                document.getElementById('portInput_ddoxs').value = data.port;
                document.getElementById('userInput_ddoxs').value = data.user;
                document.getElementById('passwordInput_ddoxs').value = data.password;
            } else {
                console.error(data.message);
            }
        })
        .catch(error => console.error('Error:', error));
    });

    document.getElementById('configForm').addEventListener('submit', function(event) {
        event.preventDefault();
        let isValid = true;
        const fields = ['ipInput_ddoxs', 'portInput_ddoxs', 'userInput_ddoxs', 'passwordInput_ddoxs'];
        fields.forEach(function(fieldId) {
            const field = document.getElementById(fieldId);
            if (field.value.trim() === '' || field.value.length < 5) {
                isValid = false;
            }
        });

        if (isValid) {
            const data = {
                ip: document.getElementById('ipInput_ddoxs').value,
                port: document.getElementById('portInput_ddoxs').value,
                user: document.getElementById('userInput_ddoxs').value,
                password: document.getElementById('passwordInput_ddoxs').value
            };

            fetch('php/g_config_ip.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(data)
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    document.getElementById('successMessage').style.display = 'block';
                    document.getElementById('errorMessage').style.display = 'none';
                } else {
                    document.getElementById('errorMessage').innerText = 'Error al guardar los datos';
                    document.getElementById('errorMessage').style.display = 'block';
                    document.getElementById('successMessage').style.display = 'none';
                }
            })
            .catch(error => {
                document.getElementById('errorMessage').innerText = 'Error en la conexión';
                document.getElementById('errorMessage').style.display = 'block';
                document.getElementById('successMessage').style.display = 'none';
            });
        } else {
            document.getElementById('errorMessage').innerText = 'Todos los campos deben tener al menos 5 caracteres';
            document.getElementById('errorMessage').style.display = 'block';
            document.getElementById('successMessage').style.display = 'none';
        }
    });
</script>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
</body>
</html>
