<?php
// delete_account.php

include '../config/conexion.php';

// Verificar si se ha enviado el parámetro `id`
if (isset($_POST['id'])) {
    $id = $_POST['id'];

    // Preparar la consulta SQL para eliminar la cuenta
    $sql = "DELETE FROM accounts WHERE id = ?";
    $stmt = $conexion->prepare($sql);
    $stmt->bind_param("i", $id);

    // Ejecutar la consulta y verificar el resultado
    if ($stmt->execute()) {
        echo "Cuenta eliminada con éxito";
    } else {
        echo "Error al eliminar la cuenta: " . $conexion->error;
    }

    $stmt->close();
} else {
    echo "ID de la cuenta no especificado.";
}

$conexion->close();
?>
