<?php
header('Content-Type: application/json; charset=utf-8');
header("Access-Control-Allow-Origin: *");

date_default_timezone_set("America/Caracas");
$fecha_actual = strftime("%Y-%m-%d %H:%M:%S", time());
session_start();
require('config/conexion.php');


if (!isset($_SESSION['usuario'])) {
    header('Location: index.php');
    exit();
}

// Verificar que se haya enviado una solicitud POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obtener los datos enviados en el cuerpo de la solicitud
    $json = file_get_contents('php://input');
    $data = json_decode($json, true);

    // Verificar que los datos necesarios estén presentes
    if (isset($data['ip'], $data['port'], $data['user'], $data['password'])) {
        $ip = $data['ip'];
        $port = $data['port'];
        $user = $data['user'];
        $password = $data['password'];

        // Concatenar los datos con el símbolo ^
        $valor = $ip . '^' . $port . '^' . $user . '^' . $password;

        try {
            // Preparar la consulta SQL para guardar los datos
            $sql = "UPDATE config SET valor = :valor WHERE id = 3";
            $stmt = $conn->prepare($sql);

            // Ejecutar la consulta y verificar si fue exitosa
            $stmt->bindParam(':valor', $valor);
            if ($stmt->execute()) {
                echo json_encode(['success' => true, 'message' => 'Datos guardados correctamente']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al guardar los datos']);
            }
        } catch (PDOException $e) {
            echo json_encode(['success' => false, 'message' => 'Error en la consulta: ' . $e->getMessage()]);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Datos incompletos']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Método no permitido']);
}

$conn = null;
?>
